tic;
% Define the functions a(x) and b(x)
c0 = 0.0001;
a = @(x) (abs(x).^(4)+c0)/2;
b = @(x) -(x)/2;

% Define numerical parameters for Riemann sums
N = 300; % Number of intervals for Riemann sums
delta_x = 1000 / N; % Step size for Riemann sums

% Compute c(x) using Riemann sum
c = @(x) sum(arrayfun(@(t) b(t)./a(t), linspace(0, x, N)) * (x/N));

% Define s(kesai)
s = @(kesai) exp(-c(kesai));

% Define M_plus(kesai) using Riemann sum
M_plus = @(kesai) sum(arrayfun(@(y) exp(c(y))./a(y), linspace(0, kesai, N)) *(kesai/N));

% Define M_minus(kesai) using Riemann sum
M_minus = @(kesai) sum(arrayfun(@(y) exp(c(y))./a(y), linspace(kesai, 0, N)) * (-kesai/N));

% Define k_plus as double-layer Riemann sum
k_plus = 0;
for i = 1:N
    kesai_i = i * delta_x;
    inner_sum = M_plus(kesai_i);
    
    if isinf(inner_sum) && s(kesai_i) == 0
        k_plus = 0;
    else
        k_plus = k_plus + s(kesai_i) * inner_sum * delta_x;
    end
end



k_minus = 0;
for i = 1:N
    kesai_i = -1000 + i * delta_x;
    inner_sum = M_minus(kesai_i);
    
    if isinf(inner_sum) && s(kesai_i) == 0
        k_minus = 0;
    else
        k_minus = k_minus + s(kesai_i) * inner_sum * delta_x;
    end
 
end



% Check if k_plus and k_minus are both infinite (use large threshold)
threshold = 1e4;
if k_plus > threshold && k_minus > threshold
    disp('The operator is unique.');
    

else
    disp('The operator is not unique.');
end

% Compute Z using Riemann sum over the entire range
N0 = 2000; % Number of intervals for Riemann sums
c_1 = @(x) sum(arrayfun(@(t) b(t)./a(t), linspace(0, x, N0)) * (x/N0));
Z = sum(arrayfun(@(y) exp(c_1(y))./a(y),linspace(-50,50,N0))*(100/N0));
fprintf('Z = %.4f\n', Z);

% End timing and display the elapsed time
elapsed_time = toc;
fprintf('Total elapsed time: %.4f seconds\n', elapsed_time);
